//+------------------------------------------------------------------+
//| Squize_MA_E_mtf                                    Squize_MA.mq4 |
//| mtf:ForexTSD.com 2007                                    Kalenzo |
//| mladen's formula   ki                bartlomiej.gorski@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 Yellow
#property indicator_color4 Goldenrod
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 5
#property indicator_width4 5

double upma[];
double dnma[];
double SqLup[]; 
double SqLdn[]; 

extern string TimeFrame = "Current time frame";
extern int Ma1Period = 5;
extern int Ma1Type   = MODE_EMA;
extern int Ma1Price  = PRICE_CLOSE;
extern string     ___= "___";
extern int Ma2Period = 21;
extern int Ma2Type   = MODE_EMA;
extern int Ma2Price  = PRICE_CLOSE;
extern string  _____ = "_______";

extern int MAsThreSHoldPips = 15;
extern bool    ATRmode   =true; 
extern int     ATRperiod =50;
extern double  ATRmultipl=0.4;

extern string  note_TimeFrames = "M1;5,15,30,60H1;240H4;1440D1;10080W1;43200MN|0-CurrentTF";
extern string   note_MA_Type    = "SMA0 EMA1 SMMA2 LWMA3";
extern string   note_Price      = "0C 1O 2H 3L 4Md 5Tp 6WghC: Md(HL/2)4,Tp(HLC/3)5,Wgh(HLCC/4)6";

string indicatorFileName;
bool   returnBars;
int    timeFrame;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexBuffer(0,upma);
   SetIndexBuffer(1,dnma);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   
   SetIndexBuffer(2,SqLup);
   SetIndexBuffer(3,SqLdn);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE);
   
   SetIndexLabel(0,"SqMA1("+Ma1Period+")["+TimeFrame+"]");
   SetIndexLabel(1,"SqMA2("+Ma2Period+")["+TimeFrame+"]");
   SetIndexLabel(2,"SqMA Env("+MAsThreSHoldPips+")("+Ma1Period+","+Ma2Period+")["+TimeFrame+"]");
   SetIndexLabel(3,"SqMA Env("+MAsThreSHoldPips+")("+Ma1Period+","+Ma2Period+")["+TimeFrame+"]");

   indicatorFileName = WindowExpertName();
   returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
   timeFrame         = stringToTimeFrame(TimeFrame);
   IndicatorShortName("SquizeMA ("+Ma1Period+","+Ma2Period+")["+TimeFrame+"]");
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{  
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { upma[0] = limit+1; return(0); }
            if (timeFrame!=Period())
            {
               limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
               for (int i=limit; i>=0; i--)
               {
                   int y = iBarShift(NULL,timeFrame,Time[i]); 
                      upma[i]  = iCustom(NULL,timeFrame,indicatorFileName,"",
                                 Ma1Period,Ma1Type,Ma1Price,"",Ma2Period,Ma2Type,Ma2Price,"",
                                 MAsThreSHoldPips,ATRmode,ATRperiod,ATRmultipl,0,y);

                      dnma[i]  = iCustom(NULL,timeFrame,indicatorFileName,"",
                                 Ma1Period,Ma1Type,Ma1Price,"",Ma2Period,Ma2Type,Ma2Price,"",
                                 MAsThreSHoldPips,ATRmode,ATRperiod,ATRmultipl,1,y);
 
                      SqLup[i] = iCustom(NULL,timeFrame,indicatorFileName,"",
                                 Ma1Period,Ma1Type,Ma1Price,"",Ma2Period,Ma2Type,Ma2Price,"",
                                 MAsThreSHoldPips,ATRmode,ATRperiod,ATRmultipl,2,y);

                      SqLdn[i] = iCustom(NULL,timeFrame,indicatorFileName,"",
                                 Ma1Period,Ma1Type,Ma1Price,"",Ma2Period,Ma2Type,Ma2Price,"",
                                 MAsThreSHoldPips,ATRmode,ATRperiod,ATRmultipl,3,y);    
               }
               return(0);
            }
   
   for( i =0; i <=limit ;i++)
   {
      double ma1 = iMA(Symbol(),0,Ma1Period,0,Ma1Type,Ma1Price,i);
      double ma2 = iMA(Symbol(),0,Ma2Period,0,Ma2Type,Ma2Price,i);       
      double madif = MathAbs(ma1-ma2);
 
         upma[i] = ma1;
         dnma[i] = ma2;
          
      if (ATRmode)   double delta = iATR(NULL,0,ATRperiod,i) * ATRmultipl/Point;
      else                  delta = MAsThreSHoldPips;


    
      if(madif/Point< delta)
    
       {
       SqLup   [i] = ma2+ delta*Point; 
       SqLdn   [i] = ma2- delta*Point; 

//                               if (ma1>ma2)
//                upma[i]  = ma1 -  (madif/2);
//                dnma[i]  = ma1 -  (madif/2);
     
         
      }
      
   }
   
   
      return(0);
  }

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M10","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,10,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}

//
//
//
//
//

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
